using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("holiday_schedule")]
public partial class HolidaySchedule
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("schedule", TypeName = "citext")]
    public string Schedule { get; set; } = null!;

    [InverseProperty("HolidaySchedule")]
    public virtual ICollection<Holiday> Holidays { get; set; } = new List<Holiday>();
}
