using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("credit_limit_collateral")]
public partial class CreditLimitCollateral
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("collateral_amount")]
    public decimal? CollateralAmount { get; set; }

    [Column("collateral_type_id")]
    public int CollateralTypeId { get; set; }

    [Column("effective_date")]
    public DateOnly EffectiveDate { get; set; }

    [Column("expiration_date")]
    public DateOnly? ExpirationDate { get; set; }

    [Column("notes", TypeName = "citext")]
    public string? Notes { get; set; }

    [Column("credit_limit_counterparty_id")]
    public int CreditLimitCounterpartyId { get; set; }

    [Column("expiration_notice", TypeName = "citext")]
    public string? ExpirationNotice { get; set; }

    [Column("is_amendment")]
    public bool IsAmendment { get; set; }

    [ForeignKey("CollateralTypeId")]
    [InverseProperty("CreditLimitCollaterals")]
    public virtual CollateralType CollateralType { get; set; } = null!;

    [InverseProperty("CreditLimitCollateral")]
    public virtual ICollection<CreditLimitCollateralBeneficiary> CreditLimitCollateralBeneficiaries { get; set; } = new List<CreditLimitCollateralBeneficiary>();

    [InverseProperty("CreditLimitCollateral")]
    public virtual ICollection<CreditLimitCollateralDoc> CreditLimitCollateralDocs { get; set; } = new List<CreditLimitCollateralDoc>();

    [InverseProperty("CreditLimitCollateral")]
    public virtual ICollection<CreditLimitCollateralProvider> CreditLimitCollateralProviders { get; set; } = new List<CreditLimitCollateralProvider>();

    [ForeignKey("CreditLimitCounterpartyId")]
    [InverseProperty("CreditLimitCollaterals")]
    public virtual CreditLimitCounterparty CreditLimitCounterparty { get; set; } = null!;
}
