using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("counterparty")]
[Index("Name", "InactiveDate", Name = "uk_counterparty_name", IsUnique = true)]
public partial class Counterparty
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string Name { get; set; } = null!;

    [Column("short_name", TypeName = "citext")]
    public string? ShortName { get; set; }

    [Column("business_type_id")]
    public int? BusinessTypeId { get; set; }

    [Column("business_sub_type_id")]
    public int? BusinessSubTypeId { get; set; }

    [Column("industry_id")]
    public int? IndustryId { get; set; }

    [Column("website", TypeName = "citext")]
    public string? Website { get; set; }

    [Column("inactive_date")]
    public DateOnly? InactiveDate { get; set; }

    [Column("hq_location_id")]
    public int? HqLocationId { get; set; }

    [Column("country_id")]
    public int? CountryId { get; set; }

    [Column("address_line1", TypeName = "citext")]
    public string? AddressLine1 { get; set; }

    [Column("address_line2", TypeName = "citext")]
    public string? AddressLine2 { get; set; }

    [Column("city", TypeName = "citext")]
    public string? City { get; set; }

    [Column("state_id")]
    public int? StateId { get; set; }

    [Column("zip", TypeName = "citext")]
    public string? Zip { get; set; }

    [Column("phone", TypeName = "citext")]
    public string? Phone { get; set; }

    [Column("federal_tax_id", TypeName = "citext")]
    public string? FederalTaxId { get; set; }

    [Column("jurisdiction_id")]
    public int? JurisdictionId { get; set; }

    [Column("internal_customer_num", TypeName = "citext")]
    public string? InternalCustomerNum { get; set; }

    [Column("internal_vendor_num", TypeName = "citext")]
    public string? InternalVendorNum { get; set; }

    [Column("notes", TypeName = "citext")]
    public string? Notes { get; set; }

    [Column("old_counterparty_id")]
    public int? OldCounterpartyId { get; set; }

    [ForeignKey("BusinessSubTypeId")]
    [InverseProperty("Counterparties")]
    public virtual BusinessSubType? BusinessSubType { get; set; }

    [ForeignKey("BusinessTypeId")]
    [InverseProperty("Counterparties")]
    public virtual BusinessType? BusinessType { get; set; }

    [InverseProperty("Counterparty")]
    public virtual ICollection<ContactCounterparty> ContactCounterparties { get; set; } = new List<ContactCounterparty>();

    [InverseProperty("Counterparty")]
    public virtual ICollection<Contract> ContractCounterparties { get; set; } = new List<Contract>();

    [InverseProperty("InternalEntity")]
    public virtual ICollection<Contract> ContractInternalEntities { get; set; } = new List<Contract>();

    [InverseProperty("Counterparty")]
    public virtual ICollection<CounterpartyDun> CounterpartyDuns { get; set; } = new List<CounterpartyDun>();

    [InverseProperty("Counterparty")]
    public virtual ICollection<CounterpartyParent> CounterpartyParentCounterparties { get; set; } = new List<CounterpartyParent>();

    [InverseProperty("Parent")]
    public virtual ICollection<CounterpartyParent> CounterpartyParentParents { get; set; } = new List<CounterpartyParent>();

    [InverseProperty("Counterparty")]
    public virtual ICollection<CounterpartyProduct> CounterpartyProducts { get; set; } = new List<CounterpartyProduct>();

    [InverseProperty("Counterparty")]
    public virtual ICollection<CounterpartyRelationship> CounterpartyRelationships { get; set; } = new List<CounterpartyRelationship>();

    [ForeignKey("CountryId")]
    [InverseProperty("Counterparties")]
    public virtual Country? Country { get; set; }

    [InverseProperty("Beneficiary")]
    public virtual ICollection<CreditLimitCollateralBeneficiary> CreditLimitCollateralBeneficiaries { get; set; } = new List<CreditLimitCollateralBeneficiary>();

    [InverseProperty("Provider")]
    public virtual ICollection<CreditLimitCollateralProvider> CreditLimitCollateralProviders { get; set; } = new List<CreditLimitCollateralProvider>();

    [InverseProperty("Counterparty")]
    public virtual ICollection<CreditLimitCounterparty> CreditLimitCounterparties { get; set; } = new List<CreditLimitCounterparty>();

    [InverseProperty("ParentCounterparty")]
    public virtual ICollection<CreditLimit> CreditLimits { get; set; } = new List<CreditLimit>();

    [InverseProperty("SourceCounterparty")]
    public virtual ICollection<CrudePath> CrudePaths { get; set; } = new List<CrudePath>();

    [InverseProperty("Counterparty")]
    public virtual ICollection<Deal> DealCounterparties { get; set; } = new List<Deal>();

    [InverseProperty("InternalEntity")]
    public virtual ICollection<Deal> DealInternalEntities { get; set; } = new List<Deal>();

    [InverseProperty("Entity")]
    public virtual ICollection<DunsNumber> DunsNumbers { get; set; } = new List<DunsNumber>();

    [InverseProperty("SourceCounterparty")]
    public virtual ICollection<GasPath> GasPaths { get; set; } = new List<GasPath>();

    [ForeignKey("HqLocationId")]
    [InverseProperty("CounterpartyHqLocations")]
    public virtual Territory? HqLocation { get; set; }

    [ForeignKey("IndustryId")]
    [InverseProperty("Counterparties")]
    public virtual Industry? Industry { get; set; }

    [InverseProperty("Counterparty")]
    public virtual ICollection<InvoiceCrude> InvoiceCrudeCounterparties { get; set; } = new List<InvoiceCrude>();

    [InverseProperty("InternalEntity")]
    public virtual ICollection<InvoiceCrude> InvoiceCrudeInternalEntities { get; set; } = new List<InvoiceCrude>();

    [InverseProperty("Counterparty")]
    public virtual ICollection<InvoiceGa> InvoiceGaCounterparties { get; set; } = new List<InvoiceGa>();

    [InverseProperty("InternalEntity")]
    public virtual ICollection<InvoiceGa> InvoiceGaInternalEntities { get; set; } = new List<InvoiceGa>();

    [ForeignKey("JurisdictionId")]
    [InverseProperty("CounterpartyJurisdictions")]
    public virtual Territory? Jurisdiction { get; set; }

    [InverseProperty("Counterparty")]
    public virtual ICollection<MeterPtrExcluded> MeterPtrExcludeds { get; set; } = new List<MeterPtrExcluded>();

    [InverseProperty("Counterparty")]
    public virtual ICollection<PaymentInstruction> PaymentInstructions { get; set; } = new List<PaymentInstruction>();

    [InverseProperty("ContractOwner")]
    public virtual ICollection<PipelineContract> PipelineContractContractOwners { get; set; } = new List<PipelineContract>();

    [InverseProperty("Counterparty")]
    public virtual ICollection<PipelineContract> PipelineContractCounterparties { get; set; } = new List<PipelineContract>();

    [InverseProperty("InternalEntity")]
    public virtual ICollection<PipelineContract> PipelineContractInternalEntities { get; set; } = new List<PipelineContract>();

    [InverseProperty("Entity")]
    public virtual ICollection<PipelineRateDiscountedCounterparty> PipelineRateDiscountedCounterparties { get; set; } = new List<PipelineRateDiscountedCounterparty>();

    [InverseProperty("Producer")]
    public virtual ICollection<PlantStatementPrice> PlantStatementPrices { get; set; } = new List<PlantStatementPrice>();

    [InverseProperty("Producer")]
    public virtual ICollection<PlantStatement> PlantStatements { get; set; } = new List<PlantStatement>();

    [InverseProperty("Producer")]
    public virtual ICollection<ProducerFee> ProducerFees { get; set; } = new List<ProducerFee>();

    [InverseProperty("Company")]
    public virtual ICollection<SalesTaxExemption> SalesTaxExemptions { get; set; } = new List<SalesTaxExemption>();

    [ForeignKey("StateId")]
    [InverseProperty("CounterpartyStates")]
    public virtual Territory? State { get; set; }

    [InverseProperty("Company")]
    public virtual ICollection<StateIncomeExemption> StateIncomeExemptions { get; set; } = new List<StateIncomeExemption>();

    [InverseProperty("Counterparty")]
    public virtual ICollection<W9Form> W9FormCounterparties { get; set; } = new List<W9Form>();

    [InverseProperty("CounterpartyParent")]
    public virtual ICollection<W9Form> W9FormCounterpartyParents { get; set; } = new List<W9Form>();
}
