using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("contract_other")]
[Index("ContractId", Name = "uk_contract_other", IsUnique = true)]
public partial class ContractOther
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("contract_id")]
    public int ContractId { get; set; }

    [Column("lc_language", TypeName = "citext")]
    public string? LcLanguage { get; set; }

    [Column("agent_clause", TypeName = "citext")]
    public string? AgentClause { get; set; }

    [ForeignKey("ContractId")]
    [InverseProperty("ContractOther")]
    public virtual Contract Contract { get; set; } = null!;
}
