using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("contact")]
public partial class Contact
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("display_name", TypeName = "citext")]
    public string DisplayName { get; set; } = null!;

    [Column("full_name", TypeName = "citext")]
    public string? FullName { get; set; }

    [Column("title", TypeName = "citext")]
    public string? Title { get; set; }

    [Column("address_line1", TypeName = "citext")]
    public string? AddressLine1 { get; set; }

    [Column("address_line2", TypeName = "citext")]
    public string? AddressLine2 { get; set; }

    [Column("city", TypeName = "citext")]
    public string? City { get; set; }

    [Column("state_id")]
    public int? StateId { get; set; }

    [Column("zip", TypeName = "citext")]
    public string? Zip { get; set; }

    [Column("country_id")]
    public int? CountryId { get; set; }

    [Column("office_phone", TypeName = "citext")]
    public string? OfficePhone { get; set; }

    [Column("cell_phone", TypeName = "citext")]
    public string? CellPhone { get; set; }

    [Column("alt_phone", TypeName = "citext")]
    public string? AltPhone { get; set; }

    [Column("fax", TypeName = "citext")]
    public string? Fax { get; set; }

    [Column("email", TypeName = "citext")]
    public string? Email { get; set; }

    [Column("notes", TypeName = "citext")]
    public string? Notes { get; set; }

    [Column("old_contact_id")]
    public int? OldContactId { get; set; }

    [InverseProperty("Contact")]
    public virtual ICollection<ContactCounterparty> ContactCounterparties { get; set; } = new List<ContactCounterparty>();

    [InverseProperty("Contact")]
    public virtual ICollection<ContactToContactType> ContactToContactTypes { get; set; } = new List<ContactToContactType>();

    [ForeignKey("CountryId")]
    [InverseProperty("Contacts")]
    public virtual Country? Country { get; set; }

    [InverseProperty("Contact")]
    public virtual ICollection<Deal> Deals { get; set; } = new List<Deal>();

    [ForeignKey("StateId")]
    [InverseProperty("Contacts")]
    public virtual Territory? State { get; set; }
}
