using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Keyless]
[Table("app_log")]
public partial class AppLog
{
    [Column("message")]
    public string? Message { get; set; }

    [Column("message_template")]
    public string? MessageTemplate { get; set; }

    [Column("level")]
    [StringLength(50)]
    public string? Level { get; set; }

    [Column("raise_date", TypeName = "timestamp without time zone")]
    public DateTime? RaiseDate { get; set; }

    [Column("exception")]
    public string? Exception { get; set; }

    [Column("properties", TypeName = "jsonb")]
    public string? Properties { get; set; }

    [Column("props_test", TypeName = "jsonb")]
    public string? PropsTest { get; set; }

    [Column("machine_name")]
    public string? MachineName { get; set; }

    [Column("module")]
    public string? Module { get; set; }

    [Column("user_id")]
    public decimal? UserId { get; set; }

    [Column("client_ip")]
    public string? ClientIp { get; set; }

    [Column("client_agent")]
    public string? ClientAgent { get; set; }

    [Column("requent_method")]
    public string? RequentMethod { get; set; }

    [Column("elapsed")]
    public decimal? Elapsed { get; set; }
}
