$moduleName = (Get-Content -Raw "../.vscode/settings.json" | ConvertFrom-Json)."fast.module.name".split('.')[1]
$siteFileName = $moduleName + "_site.7z"
$publishDir = Resolve-Path "../../../-Published"
$current_date = Get-Date -Format "yyyy-MM-dd"
& "$Env:ProgramFiles/7-Zip/7z.exe" a -t7z "${publishDir}\${siteFileName}" "${publishDir}/*" -mx1 "-xr!AfterPublish*" "-xr!settings.json"
Remove-Item -Recurse "${publishDir}/*" -Exclude "*.7z"
Add-Type -Path  "$env:USERPROFILE/AppData/Local/Programs/WinSCP/WinSCPnet.dll"
$sessionOptions = New-Object WinSCP.SessionOptions -Property @{
  Protocol                             = [WinSCP.Protocol]::Sftp
  HostName                             = "ftp.implefast.com"
  UserName                             = "superior"
  Password                             = "sngc fast"
  GiveUpSecurityAndAcceptAnySshHostKey = $true
}
$session = New-Object WinSCP.Session
$session.Open($sessionOptions)
$transferDirs = $session.ListDirectory("Transfer")
$currentDateDir = $transferDirs.Files.Where{ $PSItem.Name -eq $current_date }
if (!$currentDateDir) {
  Write-Output "Creating SFTP directory $current_date ..."
  $session.CreateDirectory("Transfer/$current_date")
}
if ($session.FileExists("Transfer/$current_date/$siteFileName")) {
  Write-Output "Removing from SFTP $siteFileName ..."
  $session.RemoveFile("Transfer/$current_date/$siteFileName")
}
$transferOps = New-Object WinSCP.TransferOptions
Write-Output "Putting to SFTP $siteFileName ..."
Write-Output $siteFileName
$publishFile = Resolve-Path "$publishDir/$siteFileName"
$session.PutFiles($publishFile, "Transfer/$current_date/$siteFileName", $false, $transferOps)
Remove-Item -Recurse "${publishDir}/*"
Write-Output "Publish Complete"
