using Microsoft.OData.Edm;
using Microsoft.OData.ModelBuilder;

Main.CustomEdmModel = Helper.GetCustomEdmModel();
Main.DirectoriesToCreate = Helper.GetDirectoriesToCreate();
Main.Configure(args, Type.GetType("Fast.Web.Logic.JobsHelper"));
await Main.RunAsync();

namespace Fast.Web
{
    public static class Helper
    {
        public static string[] GetDirectoriesToCreate()
        {
            return Array.Empty<string>();
            // return new string[] {
            //     //"SomeDirectoryName"
            // };
        }

        public static IEdmModel GetCustomEdmModel()
        {
            var builder = new ODataConventionModelBuilder();

            builder.Function("GetBusinessTypeItems").Returns<BusinessTypeListItem>();
            builder.Function("GetCollateralTypeItems").Returns<CollateralTypeListItem>();
            builder.Function("GetCounterpartyItems").Returns<CounterpartyListItem>();
            builder.Function("GetCreditLimitItems").Returns<CreditLimitListItem>();
            builder.Function("GetW9FormItems").Returns<W9FormListItem>();
            builder.Function("GetApprovalDocItems").Returns<ApprovalDocsItem>();
            builder.Function("GetCreditCollateralItems").Returns<CreditCollateralListItem>();

            return builder.GetEdmModel();
        }
    }
}
