using System.ComponentModel.DataAnnotations;

namespace Fast.Models;

public class W9FormListItem
{
    [Key] //need to set primary key for OData
    public int Id { get; set; }
    public string Name { get; set; } = "";
    [Display(Name = "Parent Business")] public string ParentCounterparty { get; set; } = "";
    [Display(Name = "Business")] public string Counterparty { get; set; } = "";
    [Display(Name = "Tax Classification")] public string TaxClassification { get; set; } = "";
    [Display(Name = "TIN 1")] public string TaxpayerIdNum1 { get; set; } = "";
    [Display(Name = "TIN 2")] public string TaxpayerIdNum2 { get; set; } = "";
    [Display(Name = "W-9 Version", Description = ",,MMM yyyy")] public DateOnly? VersionMonth { get; set; }
}
