using System.ComponentModel.DataAnnotations;

namespace Fast.Models;

public class CreditLimitListItem
{
    [Key] //need to set primary key for OData
    public int Id { get; set; }
    [Display(Name = "Parent Counterparty")] public string ParentCounterparty { get; set; } = "";
    [Display(Name = "Total Credit Limit")] public decimal TotalCreditLimit { get; set; }
    [Display(Name = "Approved Credit Limit")] public decimal ApprovedCreditLimit { get; set; }
    [Display(Name = "Over Limit Exception?")] public string IsOverLimitException { get; set; } = "";
    public decimal? ExceptionCreditLimit { get; set; }
    public DateOnly? ExceptionExpirationDate { get; set; }
    public DateOnly ApprovedDate { get; set; }
    public DateOnly? ReviewedDate { get; set; }
    public DateOnly? ExpirationDate { get; set; }
}
