using System.ComponentModel.DataAnnotations;

namespace Fast.Models;

public class CreditCollateralListItem
{
    [Key] //need to set primary key for OData
    public int CreditLimitCounterpartyId { get; set; }
    public int CreditLimitId { get; set; }
    [Display(Name = "Collateral Type")] public string CollateralType { get; set; } = "";
    [Display(Name = "Collateral Amount")] public decimal? CollateralAmount { get; set; }
    [Display(Name = "Beneficiaries")] public string Beneficiaries { get; set; } = "";
    [Display(Name = "Providers")] public string Providers { get; set; } = "";
    [Display(Name = "Effective Date")] public DateOnly? EffectiveDate { get; set; }
    [Display(Name = "Expiration Date")] public DateOnly? ExpirationDate { get; set; }
    [Display(Name = "Expiration Notice")] public string? ExpirationNotice { get; set; }
    [Display(Name = "Attachments")] public string Attachments { get; set; } = "";
    [Display(Name = "Amendment")] public string IsAmendment { get; set; } = "";
}
