namespace Fast.Models;
public class CounterpartyTreeItem
{
    public CounterpartyTreeItem() { }

    public CounterpartyTreeItem(int id, string name, string shortName, decimal? ownershipPercent)
    {
        Id = id;
        Name = name;
        ShortName = shortName;
        OwnershipPercent = ownershipPercent;
    }

    public string Text
    {
        get
        {
            string displayName = string.IsNullOrWhiteSpace(ShortName) ? Name : ShortName;
            string ownershipPercentStr = OwnershipPercent.HasValue ? OwnershipPercent.Value.ToString(@"#,#.##\%;(#,#.##)\%") : "";
            string result = ownershipPercentStr == "" ? displayName : displayName + " - " + ownershipPercentStr;
            return result;
        }
    }

    public int Id { get; set; }
    public string Name { get; set; } = "";
    public string ShortName { get; set; } = "";
    public decimal? OwnershipPercent { get; set; }
    public List<CounterpartyTreeItem> Items { get; set; } = new List<CounterpartyTreeItem>();
}
