namespace Fast.Models;
public class CounterpartyParentItem
{
    public int CounterpartyId { get; set; }
    public int ParentId { get; set; }
    public string ParentName { get; set; } = "";
    public string ParentShortName { get; set; } = "";
    public decimal OwnershipPercent { get; set; }
    public string ParentPreview
    {
        get
        {
            string displayName = string.IsNullOrWhiteSpace(ParentShortName) ? ParentName : ParentShortName;
            string ownershipPercentStr = OwnershipPercent.ToString(@"#,#.##\%;(#,#.##)\%");
            string preview = displayName + " " + ownershipPercentStr;
            return preview;
        }
    }
}
