using System.ComponentModel.DataAnnotations;

namespace Fast.Models;

public class CounterpartyListItem
{
    [Key] //need to set primary key for OData
    public int Id { get; set; }

    [Display(Name = "Name")] public string Name { get; set; } = "";
    [Display(Name = "Short Name")] public string ShortName { get; set; } = "";
    [Display(Name = "Parents")] public string Parents { get; set; } = "";
    [Display(Name = "Inactive Date")] public DateOnly? InactiveDate { get; set; }
    [Display(Name = "Products")] public string Products { get; set; } = "";
    [Display(Name = "Industry")] public string Industry { get; set; } = "";
    [Display(Name = "DUNS")] public string Duns { get; set; } = "";
    [Display(Name = "Relationships")] public string Relationships { get; set; } = "";
}
