import { inject, Injectable } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { OdataGridHelper } from '../_shared/utils/odata-grid-helper';
import { Observable } from 'rxjs';
import { State } from '@progress/kendo-data-query';
import { GridDataResult } from '@progress/kendo-angular-grid';
import * as util from '../_shared/utils/util';

export interface Item {
  Id: number;
  Name: string;
  SubTypes: string;
}

export interface Detail {
  id: number;
  name: string;
  subTypes: util.IdName[];
}

export interface RequiredData {
  hasModifyPermission: boolean;
}

@Injectable({
  providedIn: 'root'
})
export class BusinessTypeService extends OdataGridHelper {
  readonly baseUrl = `${window.location.origin}/api/BusinessType`;
  http = inject(HttpClient)

  requiredData$ = this.http.get<RequiredData>(`${this.baseUrl}/getRequiredData`)

  getItems(state: State): Observable<GridDataResult> {
    return this.fetch(`GetBusinessTypeItems`, state, null, false)
  }

  getDetail(id: number): Observable<Detail> {
    const url = `${this.baseUrl}/GetDetail?id=${id}`;
    return this.http.get<Detail>(url);
  }

  saveDetail(detail: Detail, saveType: util.SaveType): Observable<number> {
    const url = `${this.baseUrl}/SaveDetail?saveType=${saveType}`;
    return this.http.put<number>(url, detail);
  }

  deleteDetail(id: number) {
    const url = `${this.baseUrl}/DeleteDetail/${id}`;
    return this.http.delete(url);
  }

  exportItems(state: State, fileNameOriginal: string) {
    return this.fetchExport(`GetBusinessTypeItems`, state, null, fileNameOriginal);
  }

  addNewSubType(businessTypeId: number, subTypeName: string) {
    const url = `${this.baseUrl}/AddNewSubType/${businessTypeId}/${subTypeName}`;
    return this.http.post(url, null);
  };

  renameSubType(subTypeId: number, subTypeName: string) {
    const url = `${this.baseUrl}/RenameSubType/${subTypeId}/${subTypeName}`;
    return this.http.put(url, null);
  };

  deleteSubType(subTypeId: number) {
    const url = `${this.baseUrl}/DeleteSubType/${subTypeId}`;
    return this.http.delete(url);
  };
}

