import { Pipe, PipeTransform, inject } from '@angular/core';
import { SafeResourceUrl } from '@angular/platform-browser';
import { SafePipe } from './safe.pipe';
import { QueryStringBuilder } from '../utils/queryStringBuilder';

@Pipe({
  name: 'urlParams'
})
export class UrlParamsPipe implements PipeTransform {
  private safePipe = inject(SafePipe);


  transform(urlWithoutParams: string, externalParams: unknown): SafeResourceUrl {
    const params = QueryStringBuilder.buildFromObj(externalParams);
    const url = urlWithoutParams + '?' + params.toString();
    const safeUrl = this.safePipe.transform(url);
    return safeUrl;
  }
}
