import { CommonModule } from "@angular/common";
import { ChangeDetectionStrategy, Component, computed, ContentChild, input, TemplateRef, ViewChild } from "@angular/core";
import * as util from '../utils/util';
import { FAST_KENDO_COMMON, FAST_PAGE_COMMON } from "../../app.config";
import { KENDO_LISTVIEW, ListViewDataResult } from "@progress/kendo-angular-listview";
import { ListViewComponent, ItemTemplateDirective } from '@progress/kendo-angular-listview';

@Component({
  selector: 'fast-listview',
  changeDetection: ChangeDetectionStrategy.OnPush,
  standalone: true,
  imports: [CommonModule, FAST_KENDO_COMMON, FAST_PAGE_COMMON, KENDO_LISTVIEW],
  template: `
  <kendo-listview
  [class]="conditionalClasses()"
  [data]="data()"
  [loading]="loading()"
  [pageSize]="pageSize()"
  [skip]="skip()"
  [pageable]="pageable()">
    @if(itemTemplate) {
      <ng-template
        kendoListViewItemTemplate
        let-dataItem="dataItem">
        <ng-container
          [ngTemplateOutlet]="itemTemplate"
          [ngTemplateOutletContext]="{ dataItem: dataItem }"
        ></ng-container>
      </ng-template>
      }
  </kendo-listview>
  `
})
export class FastListviewComponent {
  //  listview necessities, allows a custom template
  @ContentChild(ItemTemplateDirective, { read: TemplateRef }) itemTemplate: TemplateRef<undefined>;
  @ViewChild(ListViewComponent) listView: ListViewComponent;

  util = util;
  data = input<Array<unknown> | ListViewDataResult | null>();
  pageSize = input<number>(10);
  skip = input<number>(0);
  loading = input<boolean>(false);
  pageable = input<boolean>(false);


  // stylized conditional classes input
  conditionalClasses = computed(() => {
    const classes = [] as string[];

    classes.push(...this.getCommonClasses());
    classes.push(...this.getLightClasses());
    classes.push(...this.getDarkClasses());

    const conditionalClasses = this.getConditionalClassesFromArrays(classes);
    return conditionalClasses;
  });


  getConditionalClassesFromArrays(classArray: string[]): { [key: string]: boolean } {
    const classes: { [key: string]: boolean } = {};
    classArray.forEach(className => {
      classes[className] = true;
    });
    return classes;
  }

  // make sure to put classes totally separately, otherwise it will not work (i.e. "flex flex-col h-full" will not work, but "flex" "flex-col" "h-full" will work)
  getCommonClasses() {
    return [
      "flex",
      "flex-grow",
      "w-full",
      "[&_span]:flex",
      "[&_span]:flex-grow",
      "[&_span]:p-1",
      "[&_.k-listview-item]:flex",
      "[&_.k-listview-item]:border-transparent",
      "[&_.k-listview-item]:rounded-sm",
      "[&_.k-listview-item]:hover:bg-base-blue-1000/60",
    ]
  }

  getLightClasses() {
    return [
      ""];
  }

  getDarkClasses() {
    return [
      ""];
  }
}
