using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("volume_type")]
public partial class VolumeType
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string Name { get; set; } = null!;

    [Column("reserved_field", TypeName = "citext")]
    public string? ReservedField { get; set; }

    [InverseProperty("VolumeType")]
    public virtual ICollection<Deal> Deals { get; set; } = new List<Deal>();
}
