using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("sos_crude_setting")]
[Index("UserId", Name = "uk_sos_crude_setting", IsUnique = true)]
public partial class SosCrudeSetting
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("user_id")]
    public int UserId { get; set; }

    [Column("auto_select_pipeline_id")]
    public int AutoSelectPipelineId { get; set; }

    [ForeignKey("AutoSelectPipelineId")]
    [InverseProperty("SosCrudeSettings")]
    public virtual Pipeline AutoSelectPipeline { get; set; } = null!;

    [ForeignKey("UserId")]
    [InverseProperty("SosCrudeSetting")]
    public virtual AppUser User { get; set; } = null!;
}
