using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("market_type")]
public partial class MarketType
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string? Name { get; set; }

    [Column("description", TypeName = "citext")]
    public string? Description { get; set; }

    [InverseProperty("MarketType")]
    public virtual ICollection<MarketPrice> MarketPrices { get; set; } = new List<MarketPrice>();
}
