using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("invoice_crude_line")]
[Index("DealId", Name = "ix_invoice_crude_line_deal_id")]
[Index("InvoiceId", Name = "ix_invoice_crude_line_invoice_id")]
[Index("InvoiceId", "LineNum", Name = "ix_invoice_crude_line_invoice_id_line_num")]
public partial class InvoiceCrudeLine
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("invoice_id")]
    public int InvoiceId { get; set; }

    [Column("line_num")]
    public int LineNum { get; set; }

    [Column("deal_id")]
    public int? DealId { get; set; }

    [Column("quantity")]
    public decimal? Quantity { get; set; }

    [Column("base_price")]
    public decimal? BasePrice { get; set; }

    [Column("approved_by")]
    public int? ApprovedBy { get; set; }

    [Column("approved_time")]
    public DateTime? ApprovedTime { get; set; }

    [Column("description", TypeName = "citext")]
    public string? Description { get; set; }

    [Column("delivery_meter_id")]
    public int? DeliveryMeterId { get; set; }

    [Column("roll_price")]
    public decimal? RollPrice { get; set; }

    [Column("internal_contract_num", TypeName = "citext")]
    public string? InternalContractNum { get; set; }

    [Column("counterparty_contract_num", TypeName = "citext")]
    public string? CounterpartyContractNum { get; set; }

    [Column("price_adj_1")]
    public decimal? PriceAdj1 { get; set; }

    [Column("price_adj_2")]
    public decimal? PriceAdj2 { get; set; }

    [Column("pipeline_percentage")]
    public decimal? PipelinePercentage { get; set; }

    [Column("pipeline_rate")]
    public decimal? PipelineRate { get; set; }

    [Column("pipeline_deduct")]
    public decimal? PipelineDeduct { get; set; }

    [Column("net_price")]
    public decimal? NetPrice { get; set; }

    [Column("gross_amount")]
    public decimal? GrossAmount { get; set; }

    [Column("qb_rate")]
    public decimal? QbRate { get; set; }

    [Column("qb_amount")]
    public decimal? QbAmount { get; set; }

    [Column("actual_fee")]
    public decimal? ActualFee { get; set; }

    [Column("invoice_amount")]
    public decimal? InvoiceAmount { get; set; }

    [Column("receipt_meter_id")]
    public int? ReceiptMeterId { get; set; }

    [Column("adjustment")]
    public decimal? Adjustment { get; set; }

    [ForeignKey("ApprovedBy")]
    [InverseProperty("InvoiceCrudeLines")]
    public virtual AppUser? ApprovedByNavigation { get; set; }

    [ForeignKey("DealId")]
    [InverseProperty("InvoiceCrudeLines")]
    public virtual Deal? Deal { get; set; }

    [ForeignKey("DeliveryMeterId")]
    [InverseProperty("InvoiceCrudeLineDeliveryMeters")]
    public virtual Meter? DeliveryMeter { get; set; }

    [ForeignKey("InvoiceId")]
    [InverseProperty("InvoiceCrudeLines")]
    public virtual InvoiceCrude Invoice { get; set; } = null!;

    [ForeignKey("ReceiptMeterId")]
    [InverseProperty("InvoiceCrudeLineReceiptMeters")]
    public virtual Meter? ReceiptMeter { get; set; }
}
