using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("gas_path")]
[Index("Name", "IsPathByMeter", Name = "uk_gas_path", IsUnique = true)]
public partial class GasPath
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string Name { get; set; } = null!;

    [Column("is_path_by_meter")]
    public bool IsPathByMeter { get; set; }

    [Column("source_counterparty_id")]
    public int? SourceCounterpartyId { get; set; }

    [Column("source_meter_id")]
    public int SourceMeterId { get; set; }

    [Column("source_pipe_contract_id")]
    public int? SourcePipeContractId { get; set; }

    [InverseProperty("Path")]
    public virtual ICollection<GasPathRoute> GasPathRoutes { get; set; } = new List<GasPathRoute>();

    [ForeignKey("SourceCounterpartyId")]
    [InverseProperty("GasPaths")]
    public virtual Counterparty? SourceCounterparty { get; set; }

    [ForeignKey("SourceMeterId")]
    [InverseProperty("GasPaths")]
    public virtual Meter SourceMeter { get; set; } = null!;

    [ForeignKey("SourcePipeContractId")]
    [InverseProperty("GasPaths")]
    public virtual PipelineContract? SourcePipeContract { get; set; }

    [InverseProperty("Path")]
    public virtual ICollection<TransferDeal> TransferDeals { get; set; } = new List<TransferDeal>();
}
