using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("email_setting")]
public partial class EmailSetting
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("smtp_server", TypeName = "citext")]
    public string SmtpServer { get; set; } = null!;

    [Column("port")]
    public int Port { get; set; }

    [Column("use_authentication")]
    public bool UseAuthentication { get; set; }

    [Column("user_name", TypeName = "citext")]
    public string UserName { get; set; } = null!;

    [Column("password", TypeName = "citext")]
    public string Password { get; set; } = null!;

    [Column("connection_type")]
    public int ConnectionType { get; set; }

    [Column("use_html")]
    public bool UseHtml { get; set; }
}
