using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("delivery_mode")]
public partial class DeliveryMode
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string? Name { get; set; }

    [Column("include_indicator")]
    public bool? IncludeIndicator { get; set; }

    [InverseProperty("DeliveryMode")]
    public virtual ICollection<Deal> Deals { get; set; } = new List<Deal>();
}
