using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("deal_filter")]
[Index("Name", "UserId", Name = "uk_deal_filter", IsUnique = true)]
public partial class DealFilter
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string Name { get; set; } = null!;

    [Column("user_id")]
    public int UserId { get; set; }

    [Column("is_selected")]
    public bool IsSelected { get; set; }

    [Column("columns", TypeName = "citext")]
    public string? Columns { get; set; }

    [Column("state", TypeName = "citext")]
    public string? State { get; set; }

    [InverseProperty("Filter")]
    public virtual ICollection<DealFilterParameter> DealFilterParameters { get; set; } = new List<DealFilterParameter>();

    [ForeignKey("UserId")]
    [InverseProperty("DealFilters")]
    public virtual AppUser User { get; set; } = null!;
}
