using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("county")]
[Index("Name", "StateId", Name = "idx_26342_IX_County", IsUnique = true)]
public partial class County
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("state_id")]
    public int StateId { get; set; }

    [Column("name", TypeName = "citext")]
    public string Name { get; set; } = null!;

    [Column("number", TypeName = "citext")]
    public string? Number { get; set; }

    [InverseProperty("County")]
    public virtual SalesTax? SalesTax { get; set; }

    [InverseProperty("County")]
    public virtual ICollection<SalesTaxRate> SalesTaxRates { get; set; } = new List<SalesTaxRate>();

    [ForeignKey("StateId")]
    [InverseProperty("Counties")]
    public virtual Territory State { get; set; } = null!;
}
