using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("contract_naesb")]
[Index("ContractId", Name = "idx_26263_UK_ContractNaesb", IsUnique = true)]
public partial class ContractNaesb
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("contract_id")]
    public int ContractId { get; set; }

    [Column("transaction_procedure_type_id")]
    public int? TransactionProcedureTypeId { get; set; }

    [Column("confirm_deadline")]
    public int? ConfirmDeadline { get; set; }

    [Column("confirming_party_type_id")]
    public int? ConfirmingPartyTypeId { get; set; }

    [Column("performance_obligation_type_id")]
    public int? PerformanceObligationTypeId { get; set; }

    [Column("spot_price_publication_type_id")]
    public int? SpotPricePublicationTypeId { get; set; }

    [Column("taxes_option_id")]
    public int? TaxesOptionId { get; set; }

    [Column("payment_date_option_id")]
    public int? PaymentDateOptionId { get; set; }

    [Column("wire_transfer_payment")]
    public bool WireTransferPayment { get; set; }

    [Column("ach_payment")]
    public bool AchPayment { get; set; }

    [Column("check_payment")]
    public bool CheckPayment { get; set; }

    [Column("netting_type_id")]
    public int? NettingTypeId { get; set; }

    [Column("additional_event_type_id")]
    public int? AdditionalEventTypeId { get; set; }

    [Column("early_termination_type_id")]
    public int? EarlyTerminationTypeId { get; set; }

    [Column("other_agreement_setoffs_type_id")]
    public int? OtherAgreementSetoffsTypeId { get; set; }

    [Column("choice_of_law", TypeName = "citext")]
    public string? ChoiceOfLaw { get; set; }

    [Column("confidentiality_type_id")]
    public int? ConfidentialityTypeId { get; set; }

    [Column("addendum_exhibit_b")]
    public bool AddendumExhibitB { get; set; }

    [Column("addendum_exhibit_c")]
    public bool AddendumExhibitC { get; set; }

    [Column("addendum_exhibit_d")]
    public bool AddendumExhibitD { get; set; }

    [Column("addendum_exhibit_e")]
    public bool AddendumExhibitE { get; set; }

    [Column("addendum_exhibit_f")]
    public bool AddendumExhibitF { get; set; }

    [Column("addendum_exhibit_g")]
    public bool AddendumExhibitG { get; set; }

    [Column("addendum_exhibit_h")]
    public bool AddendumExhibitH { get; set; }

    [Column("addendum_exhibit_i")]
    public bool AddendumExhibitI { get; set; }

    [Column("addendum_exhibit_j")]
    public bool AddendumExhibitJ { get; set; }

    [Column("addendum_exhibit_k")]
    public bool AddendumExhibitK { get; set; }

    [Column("addendum_exhibit_l")]
    public bool AddendumExhibitL { get; set; }

    [Column("payment_date_type_id")]
    public int? PaymentDateTypeId { get; set; }

    [Column("spot_price_publication_other", TypeName = "citext")]
    public string? SpotPricePublicationOther { get; set; }

    [Column("amendment_date")]
    public DateOnly? AmendmentDate { get; set; }

    [ForeignKey("ContractId")]
    [InverseProperty("ContractNaesb")]
    public virtual Contract Contract { get; set; } = null!;

    [ForeignKey("PaymentDateOptionId")]
    [InverseProperty("ContractNaesbs")]
    public virtual PaymentDateOption? PaymentDateOption { get; set; }

    [ForeignKey("PaymentDateTypeId")]
    [InverseProperty("ContractNaesbs")]
    public virtual PaymentDateType? PaymentDateType { get; set; }
}
