using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("contract_exhibit_b")]
public partial class ContractExhibitB
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("title", TypeName = "citext")]
    public string Title { get; set; } = null!;

    [Column("body", TypeName = "citext")]
    public string? Body { get; set; }

    [Column("ordinal")]
    public int Ordinal { get; set; }

    [Column("parent_id")]
    public int? ParentId { get; set; }

    [Column("contract_id")]
    public int? ContractId { get; set; }

    [Column("inactive_date")]
    public DateOnly? InactiveDate { get; set; }

    [ForeignKey("ContractId")]
    [InverseProperty("ContractExhibitBs")]
    public virtual Contract? Contract { get; set; }

    [InverseProperty("ContractExhibitB")]
    public virtual ICollection<ContractExhibitBSelection> ContractExhibitBSelections { get; set; } = new List<ContractExhibitBSelection>();

    [InverseProperty("Parent")]
    public virtual ICollection<ContractExhibitB> InverseParent { get; set; } = new List<ContractExhibitB>();

    [ForeignKey("ParentId")]
    [InverseProperty("InverseParent")]
    public virtual ContractExhibitB? Parent { get; set; }
}
