using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("contract_accounting")]
[Index("ContractId", Name = "uk_contract_accounting", IsUnique = true)]
public partial class ContractAccounting
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("contract_id")]
    public int ContractId { get; set; }

    [Column("invoice_address_line1", TypeName = "citext")]
    public string? InvoiceAddressLine1 { get; set; }

    [Column("invoice_address_line2", TypeName = "citext")]
    public string? InvoiceAddressLine2 { get; set; }

    [Column("invoice_city", TypeName = "citext")]
    public string? InvoiceCity { get; set; }

    [Column("invoice_zip", TypeName = "citext")]
    public string? InvoiceZip { get; set; }

    [Column("invoice_attn", TypeName = "citext")]
    public string? InvoiceAttn { get; set; }

    [Column("invoice_telephone_num", TypeName = "citext")]
    public string? InvoiceTelephoneNum { get; set; }

    [Column("invoice_fax_num", TypeName = "citext")]
    public string? InvoiceFaxNum { get; set; }

    [Column("invoice_email_address", TypeName = "citext")]
    public string? InvoiceEmailAddress { get; set; }

    [Column("do_email")]
    public bool DoEmail { get; set; }

    [Column("do_fax")]
    public bool DoFax { get; set; }

    [Column("wire_bank_name", TypeName = "citext")]
    public string? WireBankName { get; set; }

    [Column("wire_aba_num", TypeName = "citext")]
    public string? WireAbaNum { get; set; }

    [Column("wire_account_num", TypeName = "citext")]
    public string? WireAccountNum { get; set; }

    [Column("wire_other_details", TypeName = "citext")]
    public string? WireOtherDetails { get; set; }

    [Column("ach_bank", TypeName = "citext")]
    public string? AchBank { get; set; }

    [Column("ach_aba_num", TypeName = "citext")]
    public string? AchAbaNum { get; set; }

    [Column("ach_account_num", TypeName = "citext")]
    public string? AchAccountNum { get; set; }

    [Column("ach_other_details", TypeName = "citext")]
    public string? AchOtherDetails { get; set; }

    [Column("checks_attn", TypeName = "citext")]
    public string? ChecksAttn { get; set; }

    [Column("checks_address_line1", TypeName = "citext")]
    public string? ChecksAddressLine1 { get; set; }

    [Column("checks_address_line2", TypeName = "citext")]
    public string? ChecksAddressLine2 { get; set; }

    [Column("checks_city", TypeName = "citext")]
    public string? ChecksCity { get; set; }

    [Column("checks_zip", TypeName = "citext")]
    public string? ChecksZip { get; set; }

    [Column("invoice_country_id")]
    public int InvoiceCountryId { get; set; }

    [Column("checks_country_id")]
    public int ChecksCountryId { get; set; }

    [Column("invoice_state_id")]
    public int? InvoiceStateId { get; set; }

    [Column("checks_state_id")]
    public int? ChecksStateId { get; set; }

    [ForeignKey("ChecksCountryId")]
    [InverseProperty("ContractAccountingChecksCountries")]
    public virtual Country ChecksCountry { get; set; } = null!;

    [ForeignKey("ChecksStateId")]
    [InverseProperty("ContractAccountingChecksStates")]
    public virtual Territory? ChecksState { get; set; }

    [ForeignKey("ContractId")]
    [InverseProperty("ContractAccounting")]
    public virtual Contract Contract { get; set; } = null!;

    [ForeignKey("InvoiceCountryId")]
    [InverseProperty("ContractAccountingInvoiceCountries")]
    public virtual Country InvoiceCountry { get; set; } = null!;

    [ForeignKey("InvoiceStateId")]
    [InverseProperty("ContractAccountingInvoiceStates")]
    public virtual Territory? InvoiceState { get; set; }
}
