using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("contact_type")]
[Index("Name", Name = "uk_contact_type", IsUnique = true)]
public partial class ContactType
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string Name { get; set; } = null!;

    [InverseProperty("ContactType")]
    public virtual ICollection<ContactToContactType> ContactToContactTypes { get; set; } = new List<ContactToContactType>();
}
