using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("broker")]
public partial class Broker
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string? Name { get; set; }

    [Column("contact_first_name", TypeName = "citext")]
    public string? ContactFirstName { get; set; }

    [Column("contact_last_name", TypeName = "citext")]
    public string? ContactLastName { get; set; }

    [Column("contact_title", TypeName = "citext")]
    public string? ContactTitle { get; set; }

    [Column("broker_address_line1", TypeName = "citext")]
    public string? BrokerAddressLine1 { get; set; }

    [Column("broker_address_line2", TypeName = "citext")]
    public string? BrokerAddressLine2 { get; set; }

    [Column("broker_city", TypeName = "citext")]
    public string? BrokerCity { get; set; }

    [Column("broker_state_id")]
    public int? BrokerStateId { get; set; }

    [Column("broker_zip_code", TypeName = "citext")]
    public string? BrokerZipCode { get; set; }

    [Column("broker_country", TypeName = "citext")]
    public string? BrokerCountry { get; set; }

    [Column("broker_office_phone", TypeName = "citext")]
    public string? BrokerOfficePhone { get; set; }

    [Column("broker_cell_phone", TypeName = "citext")]
    public string? BrokerCellPhone { get; set; }

    [Column("broker_fax", TypeName = "citext")]
    public string? BrokerFax { get; set; }

    [Column("broker_website", TypeName = "citext")]
    public string? BrokerWebsite { get; set; }

    [Column("broker_additional_phone", TypeName = "citext")]
    public string? BrokerAdditionalPhone { get; set; }

    [Column("broker_home_phone", TypeName = "citext")]
    public string? BrokerHomePhone { get; set; }

    [Column("broker_email_address", TypeName = "citext")]
    public string? BrokerEmailAddress { get; set; }

    [Column("broker_type", TypeName = "citext")]
    public string? BrokerType { get; set; }

    [Column("broker_memo", TypeName = "citext")]
    public string? BrokerMemo { get; set; }

    [Column("broker_accounts", TypeName = "citext")]
    public string? BrokerAccounts { get; set; }

    [Column("initial_margin", TypeName = "citext")]
    public string? InitialMargin { get; set; }

    [Column("maintenance_margin", TypeName = "citext")]
    public string? MaintenanceMargin { get; set; }

    [Column("total_accounts_value", TypeName = "citext")]
    public string? TotalAccountsValue { get; set; }

    [Column("deposit", TypeName = "citext")]
    public string? Deposit { get; set; }

    [Column("commission")]
    public double? Commission { get; set; }

    [Column("commission_after_hour")]
    public double? CommissionAfterHour { get; set; }

    [Column("commission4_efs")]
    public double? Commission4Efs { get; set; }

    [ForeignKey("BrokerStateId")]
    [InverseProperty("Brokers")]
    public virtual Territory? BrokerState { get; set; }

    [InverseProperty("Broker")]
    public virtual ICollection<Deal> Deals { get; set; } = new List<Deal>();
}
