**Summary**
A Microsoft Business Central comprehensive solution for a custom API page and codeunit named "SuperiorInvoiceAPI" designed to handle the creation and posting of Sales Invoices, wrapping the functionality (Header, Lines, and Dimension creation) into a single custom AL API call.

**Inputs**
The API accepts a JSON object mirroring the structure of the provided C# `BcInvoice` and `BcInvoiceLine` classes.
    *   **Header Fields:** CustomerNum, Number, ExternalDocumentNumber, DocumentDate, PostingDate, DueDate.
    *   **Line Fields:** LineType (Comment, G/L Account, Item, Resource, Fixed Asset, Charge (Item)), LineTypeNumber, UnitPrice, TaxCode, Quantity.
    *   **Dimension Fields (Per Line):** ProdMonth, MeterCode, StateLocation, SdealNumber, PdealNumber, PipeCode.

**Logic & Validation:**
    *   **Customer Validation:** During record insert (OnInsertRecord trigger), verify that the CustomerNum exists in the Customer table. If the customer does not exist, throw error: \"Customer '%1' does not exist.\" This occurs before the record is inserted, causing an HTTP 400 Bad Request response that the C# application can catch and handle.
    *   **Duplicate Check:** Before processing, verify if a Sales Invoice with the provided "Number" already exists. If it does, throw a specific error and abort the transaction.
    *   **Dimension Management:** For every line item, process the five specific custom dimensions ("PROD MTH", "METER", "STATE LOC", "SDEAL#", "PDEAL#", "PIPE").
        *   Check the "Dimension Value" table for the existence of these values.
        *   If a value does not exist, programmatically create it in the "Dimension Value" table to prevent errors.
        *   Assign these dimensions to the specific Sales Invoice Line being created.
    *   **Transaction Safety:** Ensure the entire operation (Header creation, Line creation, Dimension assignment) is treated as a single atomic transaction.

**Reference C# Class Structure:**
```csharp
public class BcInvoice
{
    public string? CustomerNum { get; set; } // Maps to "Sell-to Customer No."
    public string? Number { get; set; } // Maps to Sales Header "No."
    public string? ExternalDocumentNumber { get; set; } // Maps to "External Document No."
    public DateTime DocumentDate { get; set; } // Maps to "Document Date"
    public DateOnly PostingDate { get; set; } // Maps to "Posting Date"
    public DateOnly? DueDate { get; set; } // Maps to "Due Date"
    public List<BcInvoiceLine> InvoiceLines { get; set; } = new List<BcInvoiceLine>();
}

public class BcInvoiceLine
{
    public string? LineType { get; set; } // Maps to "Type"  e.g., "Item", "G/L Account"
    public string? LineTypeNumber { get; set; } // Maps to Sales Line "No."
    public decimal? UnitPrice { get; set; } // Maps to "Unit Price"
    public string? TaxCode { get; set; } // Maps to "Tax Group Code"
    public decimal? Quantity { get; set; } // Maps to "Quantity"
    // Custom Dimensions
    public DateOnly? ProdMonth { get; set; } // Code: PROD MTH
    public string? MeterCode { get; set; }   // Code: METER
    public string? StateLocation { get; set; } // Code: STATE LOC
    public string? SdealNumber { get; set; }   // Code: SDEAL#
    public string? PdealNumber { get; set; }   // Code: PDEAL#
    public string? PipeCode { get; set; }      // Code: PIPE
}
```