table 50149 "Superior Invoice Request Line"
{
    Caption = 'Superior Invoice Request Line';
    DataClassification = CustomerContent;
    InherentEntitlements = X;
    InherentPermissions = X;

    fields
    {
        field(1; "Document ID"; Guid)
        {
            Caption = 'Document ID';
            DataClassification = SystemMetadata;
            TableRelation = "Superior Invoice Request"."ID";
        }
        field(2; "Line No."; Integer)
        {
            Caption = 'Line No.';
            DataClassification = SystemMetadata;
        }
        field(10; "Line Type"; Text[30])
        {
            Caption = 'Line Type';
            DataClassification = CustomerContent;
        }
        field(20; "Line Type Number"; Code[20])
        {
            Caption = 'Line Type Number';
            DataClassification = CustomerContent;
        }
        field(30; "Unit Price"; Decimal)
        {
            Caption = 'Unit Price';
            DataClassification = CustomerContent;
        }
        field(40; "Tax Code"; Code[20])
        {
            Caption = 'Tax Code';
            DataClassification = CustomerContent;
        }
        field(50; "Quantity"; Decimal)
        {
            Caption = 'Quantity';
            DataClassification = CustomerContent;
        }
        // Dimension Fields
        field(100; "Prod Month"; Text[50])
        {
            Caption = 'Prod Month';
            DataClassification = CustomerContent;
        }
        field(110; "Meter Code"; Text[50])
        {
            Caption = 'Meter Code';
            DataClassification = CustomerContent;
        }
        field(120; "State Location"; Text[50])
        {
            Caption = 'State Location';
            DataClassification = CustomerContent;
        }
        field(130; "Sdeal Number"; Text[50])
        {
            Caption = 'Sdeal Number';
            DataClassification = CustomerContent;
        }
        field(140; "Pipe Code"; Text[50])
        {
            Caption = 'Pipe Code';
            DataClassification = CustomerContent;
        }
        field(150; "Pdeal Number"; Text[50])
        {
            Caption = 'Pdeal Number';
            DataClassification = CustomerContent;
        }
        field(200; "System ID"; Guid)
        {
            Caption = 'System ID';
            DataClassification = SystemMetadata;
        }
    }

    keys
    {
        key(PK; "Document ID", "Line No.")
        {
            Clustered = true;
        }
    }

    trigger OnInsert()
    var
        InvoiceRequestLine: Record "Superior Invoice Request Line";
    begin
        if IsNullGuid("System ID") then
            "System ID" := CreateGuid();

        // Auto-assign line number if not set
        if "Line No." = 0 then begin
            InvoiceRequestLine.SetRange("Document ID", "Document ID");
            if InvoiceRequestLine.FindLast() then
                "Line No." := InvoiceRequestLine."Line No." + 10000
            else
                "Line No." := 10000;
        end;
    end;
}
