table 50148 "Superior Invoice Request"
{
    Caption = 'Superior Invoice Request';
    DataClassification = CustomerContent;
    InherentEntitlements = X;
    InherentPermissions = X;

    fields
    {
        field(1; "ID"; Guid)
        {
            Caption = 'ID';
            DataClassification = SystemMetadata;
        }
        // Header Input Fields
        field(10; "Customer Num"; Code[20])
        {
            Caption = 'Customer Num';
            DataClassification = CustomerContent;
        }
        field(20; "Number"; Code[20])
        {
            Caption = 'Number';
            DataClassification = CustomerContent;
        }
        field(30; "External Document Number"; Code[35])
        {
            Caption = 'External Document Number';
            DataClassification = CustomerContent;
        }
        field(40; "Document Date"; Date)
        {
            Caption = 'Document Date';
            DataClassification = CustomerContent;
        }
        field(50; "Posting Date"; Date)
        {
            Caption = 'Posting Date';
            DataClassification = CustomerContent;
        }
        field(60; "Due Date"; Date)
        {
            Caption = 'Due Date';
            DataClassification = CustomerContent;
        }
        // Output Fields
        field(100; "Result Document No."; Code[20])
        {
            Caption = 'Result Document No.';
            DataClassification = CustomerContent;
        }
        field(110; "Status"; Enum "Superior Invoice Status")
        {
            Caption = 'Status';
            DataClassification = CustomerContent;
        }
        field(120; "Error Message"; Text[2048])
        {
            Caption = 'Error Message';
            DataClassification = CustomerContent;
        }
        // Tracking Fields
        field(130; "Created At"; DateTime)
        {
            Caption = 'Created At';
            DataClassification = SystemMetadata;
        }
        field(140; "Processed"; Boolean)
        {
            Caption = 'Processed';
            DataClassification = SystemMetadata;
        }
    }

    keys
    {
        key(PK; "ID")
        {
            Clustered = true;
        }
        key(Cleanup; "Processed", "Created At")
        {
            // For cleanup job to find old processed records
        }
    }

    trigger OnInsert()
    begin
        if IsNullGuid("ID") then
            "ID" := CreateGuid();
        "Created At" := CurrentDateTime();
        "Processed" := false;
    end;

    trigger OnDelete()
    var
        InvoiceRequestLine: Record "Superior Invoice Request Line";
    begin
        // Cascade delete lines when header is deleted
        InvoiceRequestLine.SetRange("Document ID", "ID");
        InvoiceRequestLine.DeleteAll();
    end;
}
