page 50147 "Superior Invoice API Test"
{
    PageType = Card;
    Caption = 'Superior Invoice API Test Runner';
    ApplicationArea = All;
    UsageCategory = Tasks;
    SourceTable = Integer;
    SourceTableTemporary = true;
    Editable = true;

    // This page provides a UI to run and debug the Superior Invoice API.
    //
    // HOW TO USE:
    // 1. Set breakpoints in "Superior Invoice API" or "Superior Invoice API Test" codeunits
    // 2. Press F5 to start debugging
    // 3. Search for "Superior Invoice API Test" in Tell Me (Alt+Q)
    // 4. Configure your test values and click the desired test action

    layout
    {
        area(Content)
        {
            group(Configuration)
            {
                Caption = 'Test Configuration';
            }
            group(Instructions)
            {
                Caption = 'Debugging Instructions';
            }
        }
    }

    actions
    {
        area(Processing)
        {
            action(RunFullTest)
            {
                ApplicationArea = All;
                Caption = 'Run Full Test';
                ToolTip = 'Creates a complete invoice with header, multiple lines, and all dimensions';
                Image = TestFile;

                trigger OnAction()
                var
                    TestCU: Codeunit "Superior Invoice API Test";
                begin
                    TestCU.RunFullTest();
                end;
            }
            action(RunMinimalTest)
            {
                ApplicationArea = All;
                Caption = 'Run Minimal Test';
                ToolTip = 'Creates a simple invoice with minimal data to test basic flow';
                Image = TestReport;

                trigger OnAction()
                var
                    TestCU: Codeunit "Superior Invoice API Test";
                begin
                    TestCU.RunMinimalTest();
                end;
            }
            action(RunDuplicateTest)
            {
                ApplicationArea = All;
                Caption = 'Run Duplicate Test';
                ToolTip = 'Tests that duplicate invoice detection works correctly';
                Image = ErrorLog;

                trigger OnAction()
                var
                    TestCU: Codeunit "Superior Invoice API Test";
                begin
                    TestCU.RunDuplicateTest();
                end;
            }
            action(RunJsonTest)
            {
                ApplicationArea = All;
                Caption = 'Run JSON Test';
                ToolTip = 'Tests the API by parsing a JSON payload and inserting records (simulates deep insert)';
                Image = ImportCodes;

                trigger OnAction()
                var
                    TestCU: Codeunit "Superior Invoice API Test";
                begin
                    TestCU.RunJsonTest();
                end;
            }
            action(OpenUnpostedSalesInvoices)
            {
                ApplicationArea = All;
                Caption = 'Unposted Sales Invoices';
                ToolTip = 'Opens the Sales Invoices list to view unposted invoices';
                Image = SalesInvoice;
                RunObject = page "Sales Invoice List";
            }
            action(OpenPostedSalesInvoices)
            {
                ApplicationArea = All;
                Caption = 'Posted Sales Invoices';
                ToolTip = 'Opens the Posted Sales Invoices list to view posted invoices';
                Image = PostedOrder;
                RunObject = page "Posted Sales Invoices";
            }
            action(CleanupTestData)
            {
                ApplicationArea = All;
                Caption = 'Cleanup Test Data';
                ToolTip = 'Removes all test invoices created by this test runner (TEST-*, MIN-*, DUP-*, JSON-*). Deletes from Sales Header, Posted Sales Invoices, and Request tables.';
                Image = Delete;

                trigger OnAction()
                var
                    TestCU: Codeunit "Superior Invoice API Test";
                begin
                    if Confirm('Delete all test invoices (TEST-*, MIN-*, DUP-*, JSON-*)?') then
                        TestCU.CleanupTestData();
                end;
            }
        }
        area(Promoted)
        {
            actionref(RunFullTest_Promoted; RunFullTest)
            {
            }
            group(MoreTests_Promoted)
            {
                Caption = 'More Tests';
                Image = TestReport;

                actionref(RunMinimalTest_Promoted; RunMinimalTest)
                {
                }
                actionref(RunDuplicateTest_Promoted; RunDuplicateTest)
                {
                }
                actionref(RunJsonTest_Promoted; RunJsonTest)
                {
                }
            }
            group(ViewInvoices_Promoted)
            {
                Caption = 'View Invoices';
                Image = SalesInvoice;

                actionref(OpenUnpostedSalesInvoices_Promoted; OpenUnpostedSalesInvoices)
                {
                }
                actionref(OpenPostedSalesInvoices_Promoted; OpenPostedSalesInvoices)
                {
                }
            }
            actionref(CleanupTestData_Promoted; CleanupTestData)
            {
            }
        }
    }

    trigger OnOpenPage()
    var
        DummyRec: Record Integer;
    begin
        // Insert a dummy record to make the page work
        DummyRec.Number := 1;
        Rec := DummyRec;
        Rec.Insert();
    end;
}
