page 50149 "Superior Invoice API Lines"
{
    PageType = API;
    APIPublisher = 'SuperiorNaturalGasCorporation';
    APIGroup = 'sales';
    APIVersion = 'v2.0';
    EntityName = 'invoiceLine';
    EntitySetName = 'invoiceLines';
    SourceTable = "Superior Invoice Request Line";
    DelayedInsert = true;
    InsertAllowed = true;
    ModifyAllowed = false;
    DeleteAllowed = false;
    ODataKeyFields = "System ID";
    Permissions = tabledata "Superior Invoice Request Line" = RIMD;

    layout
    {
        area(Content)
        {
            repeater(Group)
            {
                field(id; Rec."System ID")
                {
                    Caption = 'ID';
                    Editable = false;
                }
                field(lineType; Rec."Line Type")
                {
                    Caption = 'Line Type';
                }
                field(lineTypeNumber; Rec."Line Type Number")
                {
                    Caption = 'Line Type Number';
                }
                field(unitPrice; Rec."Unit Price")
                {
                    Caption = 'Unit Price';
                }
                field(taxCode; Rec."Tax Code")
                {
                    Caption = 'Tax Code';
                }
                field(quantity; Rec."Quantity")
                {
                    Caption = 'Quantity';
                }
                field(prodMonth; Rec."Prod Month")
                {
                    Caption = 'Prod Month';
                }
                field(meterCode; Rec."Meter Code")
                {
                    Caption = 'Meter Code';
                }
                field(stateLocation; Rec."State Location")
                {
                    Caption = 'State Location';
                }
                field(sdealNumber; Rec."Sdeal Number")
                {
                    Caption = 'Sdeal Number';
                }
                field(pdealNumber; Rec."Pdeal Number")
                {
                    Caption = 'Pdeal Number';
                }
                field(pipeCode; Rec."Pipe Code")
                {
                    Caption = 'Pipe Code';
                }
            }
        }
    }
}
