using Fast.Web;
using Fast.Web.Models;
using Microsoft.OData.Edm;
using Microsoft.OData.ModelBuilder;

Main.CustomEdmModel = Helper.GetCustomEdmModel();
Main.DirectoriesToCreate = Helper.GetDirectoriesToCreate();
Main.Configure(args, Type.GetType("Fast.Web.Logic.JobsHelper"));
await Main.RunAsync();

namespace Fast.Web
{
    public static class Helper
    {
        public static string[] GetDirectoriesToCreate()
        {
            return new string[] {
                "SalesTaxExemptionCertificates",
                "StateTaxExemptionCertificates"
            };
        }

        public static IEdmModel GetCustomEdmModel()
        {
            var builder = new ODataConventionModelBuilder();

            builder.Function("GetSalesTaxRateItems").Returns<SalesTaxRateListItem>();
            builder.Function("GetSalesTaxExemptionItems").Returns<SalesTaxExemptionListItem>();
            builder.Function("GetQualityBankItems").Returns<QualityBankItem>();
            builder.Function("GetSeveranceTaxItems").Returns<SeveranceTaxListItem>();
            builder.Function("GetStateIncomeExemptionItems").Returns<StateIncomeExemptionListItem>();

            return builder.GetEdmModel();
        }
    }
}
