﻿using System;
using System.ComponentModel.DataAnnotations;

namespace Fast.Web.Models;

public class SeveranceTaxListItem
{
    [Key] //need to set primary key for OData

    [Display(Name = "State")] public string? StateName { get; set; } = "";
    public int? StateId { get; set; }
    [Display(Name = "Gas Rate", Description = ",,{0:p5}")] public decimal? GasRate { get; set; }
    [Display(Name = "Gas Regulatory Fee", Description = ",,{0:c5}")] public decimal? GasRegulatoryFee { get; set; }
    [Display(Name = "Crude Rate", Description = ",,{0:p5}")] public decimal? CrudeRate { get; set; }
    [Display(Name = "Crude Regulatory Fee", Description = ",,{0:c5}")] public decimal? CrudeRegulatoryFee { get; set; }
}