﻿using System;
using System.ComponentModel.DataAnnotations;

namespace Fast.Web.Models;

public class SalesTaxRateListItem
{
    [Key] //need to set primary key for OData
    public int SalesTaxRateId { get; set; }

    [Display(Name = "County")] public string CountyName { get; set; } = "";

    [Display(Name = "State")] public string StateName { get; set; } = "";
    [Display(Name = "Rate", Description = ",,{0:p5}")] public decimal Rate { get; set; }
    [Display(Name = "Inactive Date", Description = ",,{0:d}")] public DateOnly? InactiveDate { get; set; }
}