﻿using System.ComponentModel.DataAnnotations;

namespace Fast.Web.Models;

public class QualityBankItem
{
    [Key] //need to set primary key for OData
    public int Id { get; set; }

    public int? CounterPartyId { get; set; }

    [Display(Name = "CounterParty")] public string CounterPartyName { get; set; } = "";

    [Display(Name = "Month", Description = ",,MMM yyyy")] public DateOnly Month { get; set; }

    [Display(Name = "Contract")] public string ContractNum { get; set; } = "";

    [Display(Name = "As Of Date", Description = ",,{0:d}")] public DateOnly AsOfDate { get; set; }

}