using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;

namespace Fast.Web.Models;

public class ActualsCommonListItem
{
    [Display(Name = "Counterparty")] public string? CounterpartyName { get; set; }
    [Display(Name = "Receipt Counterparty Short")] public string? ReceiptCounterpartyShort { get; set; }
    [Display(Name = "Delivery Counterparty Short")] public string? DeliveryCounterpartyShort { get; set; }
    [Display(Name = "Ticket #")] public string? TicketNum { get; set; }
    [Display(Name = "Delivery Deal #")] public string? DeliveryDealNum { get; set; }
    [Display(Name = "Receipt Deal #")] public string? ReceiptDealNum { get; set; }
    [Display(Name = "Pipeline")] public string? PipeName { get; set; }
    [Display(Name = "Point")] public string? PointName { get; set; }
    [Display(Name = "Last Transfer")] public string? LastTransferNum { get; set; }
    [Display(Name = "Receipt Meter")] public string? ReceiptMeterName { get; set; }
    [Display(Name = "Delivery Meter")] public string? DeliveryMeterName { get; set; }
    [Display(Name = "T&E Meter")] public string? TneMeterName { get; set; }
    [Display(Name = "P/L Contract")] public string? PipeContractName { get; set; }
    [Display(Name = "Link")] public bool IsLinked { get; set; }
    [Display(Name = "Price", Description = "150,1,{0:c5}")] public decimal? Price { get; set; }
    [Display(Name = "Price Adj.", Description = "150,1,{0:c5}")] public decimal? PriceAdj { get; set; }
    [Display(Name = "Actual Fee", Description = "150,1,{0:c5}")] public decimal? ActualFee { get; set; }
    [Display(Name = "Adjustment", Description = "{0:N2}")] public decimal? Adjustment { get; set; }
    [Display(Name = "T&E", Description = "150,1,{0:c5}")] public decimal? TransportRate { get; set; }
    [Display(Name = "Invoice Price", Description = "150,1,{0:c5}")] public decimal? InvoicePrice { get; set; }
    [Display(Name = "Amount", Description = "150,1,{0:c5}")] public decimal? Amount { get; set; }
    public virtual decimal NomVolume { get; set; }
    public virtual decimal? ActualVolume { get; set; }
    [NotMapped] public bool IsVolumeEdited { get; set; } = false;
    [NotMapped] public bool IsPriceEdited { get; set; } = false;
    [NotMapped] public bool IsPriceAdjEdited { get; set; } = false;
    [NotMapped] public bool IsTransportRateEdited { get; set; } = false;
    [NotMapped] public bool IsActualFeeEdited { get; set; } = false;
    [NotMapped] public bool IsAdjustmentEdited { get; set; } = false;
    [NotMapped] public bool IsLinkEdited { get; set; } = false;
    [NotMapped] public DateOnly SaveDate { get; set; }
    [NotMapped] public int? PipeId { get; set; }
    public DateOnly Date { get; set; }
    public int? PointId { get; set; }
    public int ReceiptMeterId { get; set; }
    public int DeliveryMeterId { get; set; }
    public int? TneMeterId { get; set; }
    public int? DealId { get; set; }
    public int? TransferDealId { get; set; }
    public int? CounterpartyId { get; set; }
    public int ActualTypeId { get; set; }
    public int SupplyNomId { get; set; }
    public int MarketNomId { get; set; }
    public int? LastTransferId { get; set; }
    public int? PipeContractId { get; set; }
    public bool NonJurisdictional { get; set; }
    public bool HasTransfers { get; set; }
    public int TransferCount { get; set; }
    public int? TneMeterDeductLegNum { get; set; }
    public string TransportCalcText = "";
}
