import { inject, Injectable } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { OdataGridHelper } from '../_shared/utils/odata-grid-helper';
import { Observable } from 'rxjs';
import { State } from '@progress/kendo-data-query';
import { GridDataResult } from '@progress/kendo-angular-grid';
import { IdName } from '../_shared/utils/util'

export interface Item {
  StateId: number;
  StateName: string;
  GasRate: number;
  GasRegulatoryFee: number;
  CrudeRate: number;
  CrudeRegulatoryFee: number;
}

export interface Detail {
  stateId: number;
  gasRate: number;
  gasRegulatoryFee: number;
  crudeRate: number;
  crudeRegulatoryFee: number;
}

export interface RequiredData {
  hasModifyPermission: boolean;
  states: IdName[];
}

export enum SaveType {
  New = 1,
  Normal = 2
}

@Injectable({
  providedIn: 'root'
})
export class SeveranceTaxService extends OdataGridHelper {
  private baseUrl = `${window.location.origin}/api/SeveranceTax`;
  http = inject(HttpClient);

  requiredData$ = this.http.get<RequiredData>(`${this.baseUrl}/getRequiredData`)

  getItems(state: State): Observable<GridDataResult> {
    return this.fetch(`GetSeveranceTaxItems`, state, null, false)
  }

  getDetail(stateId: number): Observable<Detail> {
    const url = `${this.baseUrl}/GetDetail?stateid=${stateId}`;
    return this.http.get<Detail>(url);
  }

  saveDetail(detail: Detail, saveType: SaveType, originalStateId: number): Observable<number> {
    const originalStateIdStr = originalStateId ? originalStateId.toString() : '';
    const url = `${this.baseUrl}/SaveDetail?saveType=${saveType}&originalStateId=${originalStateIdStr}`;
    return this.http.put<number>(url, detail);
  }

  deleteDetail(stateId: number) {
    const url = `${this.baseUrl}/DeleteDetail/${stateId}`;
    return this.http.delete(url);
  }

  exportItems(state: State, fileNameOriginal: string) {
    return this.fetchExport(`GetSeveranceTaxItems`, state, null, fileNameOriginal);
  }
}
