import { Injectable } from "@angular/core";
import { FastToastComponent } from "../elements/fast-toast.component";

@Injectable({
  providedIn: "root",
})

export class ToastService {
  toastComponent: FastToastComponent;

  success(message: string) {
    this.toastComponent.show({ message: message, type: "success" });
  }

  error(message: string) {
    this.toastComponent.show({ message: message, type: "error" });
  }

  warning(message: string) {
    this.toastComponent.show({ message: message, type: "warning" });
  }

  info(message: string) {
    this.toastComponent.show({ message: message, type: "info" });
  }

}