import { Directive, HostListener, ElementRef, Input, inject } from '@angular/core';
import * as util from '../utils/util';

@Directive({
  selector: '[hover-class]'
})
export class HoverClassDirective {
  private elementRef = inject(ElementRef);


  @Input('hover-class') hoverClass: string;

  @HostListener('mouseenter') onMouseEnter() {
    this.update('add');
  }

  @HostListener('mouseleave') onMouseLeave() {
    this.update('remove');
  }

  protected update(action: 'add' | 'remove'): void {
    const elem = this.elementRef.nativeElement as HTMLElement;
    this.hoverClass.split(' ').forEach(item => {
      if (!util.isNullOrWhitespace(item))
        elem.classList[action](item);
    });
  }
}
