import { argv } from "process";

const portArgIndex = argv.indexOf("--port");
let port = portArgIndex !== -1 ? argv[portArgIndex + 1] : undefined;

if (port)
  port = "443" + port.substring(3); // replace 543 with 443

const proxyConfig = port ? getProxyConfig() : {};

if (!port) {
  console.log(`
******************************************************************************************
Port not found, proxy not configured. Perhaps use the vscode "ng serve" task in tasks.json
******************************************************************************************\n`);
}

export default proxyConfig;

function getProxyConfig() {
  const newTarget = `https://127.0.0.1:${port}`;
  // "secure: false" still uses https, but does not verify the certificate
  // production does not use this proxy
  // https://stackoverflow.com/questions/77986335/how-to-configure-proxy-with-angular-17-esbuild-vite

  return {
    "/api": {
      target: newTarget,
      secure: false,
      changeOrigin: true,
    },
    "/hangfire": {
      target: newTarget,
      secure: false,
    },
    "/odata": {
      target: newTarget,
      secure: false,
    },
    "/pdfjs": {
      target: newTarget,
      secure: false,
    },
    "/signin-oidc": {
      target: newTarget,
      secure: false,
    },
  };
}
