namespace Fast.Shared.Models;

[Serializable]
public class IdDateOnly : IEquatable<IdDateOnly>
{
    public int Id;
    public DateOnly? Date;

    public IdDateOnly()
    {
    }

    public IdDateOnly(int Id, DateOnly? Date)
    {
        this.Id = Id;
        this.Date = Date;
    }

    public override bool Equals(object? obj)
    {
        return Equals(obj as IdDateOnly);
    }

    public bool Equals(IdDateOnly? other)
    {
        return Id == other?.Id &&
               Date == other?.Date;
    }

    public override int GetHashCode()
    {
        return HashCode.Combine(Id, Date);
    }

    public static bool operator ==(IdDateOnly pair1, IdDateOnly pair2)
    {
        return EqualityComparer<IdDateOnly>.Default.Equals(pair1, pair2);
    }

    public static bool operator !=(IdDateOnly pair1, IdDateOnly pair2)
    {
        return !(pair1 == pair2);
    }
}
