//extend the auto-generated database models to implement the interface
namespace Fast.Shared.Database.Models


{
    public partial class DealFilterParameter : IFilterParameter { }
    public partial class ReportFilterParameter : IFilterParameter { }
}

namespace Fast.Shared.Models
{
    public interface IFilterParameter
    {
        int Id { get; set; }
        string Name { get; set; }
        int FilterId { get; set; }
        string Preview { get; set; }
        string Value1 { get; set; }
        string? Value2 { get; set; }
    }

    public class FilterParameterItem
    {
        public int Id { get; set; }
        public string Name { get; set; } = "";
        public int FilterId { get; set; }
        public int DataSourceId { get; set; }
        public string Preview { get; set; } = "";
        public string Value1 { get; set; } = "";
        public string? Value2 { get; set; }

        public static FilterParameterItem ConvertDbParamToParamItem<T>(T dbParam) where T : IFilterParameter
        {
            FilterParameterItem item = new();
            item.Id = dbParam.Id;
            item.Name = dbParam.Name;
            item.FilterId = dbParam.FilterId;
            item.Preview = dbParam.Preview;
            item.Value1 = dbParam.Value1;
            item.Value2 = dbParam.Value2;

            if (dbParam is ReportFilterParameter reportFilterParam)
                item.DataSourceId = reportFilterParam.DataSourceId;

            return item;
        }

        public static List<FilterParameterItem> ConvertDbParamsToParamItems<T>(List<T> dbParams) where T : IFilterParameter
        {
            List<FilterParameterItem> items = new();
            foreach (var dbParam in dbParams)
                items.Add(FilterParameterItem.ConvertDbParamToParamItem(dbParam));

            return items;
        }

        public static T ConvertParamItemToDbParam<T>(FilterParameterItem item) where T : IFilterParameter, new()
        {
            T dbParam = new();
            dbParam.Id = item.Id;
            dbParam.Name = item.Name;
            dbParam.FilterId = item.FilterId;
            dbParam.Preview = item.Preview;
            dbParam.Value1 = item.Value1;
            dbParam.Value2 = item.Value2;

            if (dbParam is ReportFilterParameter reportFilterParam)
                reportFilterParam.DataSourceId = item.DataSourceId;

            return dbParam;
        }

        public static List<T> ConvertParamItemsToDbParams<T>(List<FilterParameterItem> items) where T : IFilterParameter, new()
        {
            List<T> dbParams = new();
            foreach (var item in items)
                dbParams.Add(FilterParameterItem.ConvertParamItemToDbParam<T>(item));

            return dbParams;
        }
    }
}
