namespace Fast.Shared.Logic.ValuationByPath;

public class PathValuationResult
{
    public DateOnly Day { get; set; }
    public string ReceiptDeal { get; set; } = "";
    public string ReceiptInternalEntity { get; set; } = "";
    public string ReceiptCounterparty { get; set; } = "";
    public string ReceiptCounterpartyShort { get; set; } = "";
    public string ReceiptDealPurpose { get; set; } = "";
    public string ReceiptBaseOrSwing { get; set; } = "";
    public string ReceiptPipe { get; set; } = "";
    public string ReceiptPoint { get; set; } = "";
    public string ReceiptMeter { get; set; } = "";
    public string ReceiptPipeContract { get; set; } = "";
    public string ReceiptPipeContractOwner { get; set; } = "";
    public decimal ReceiptNomVol { get; set; }
    public decimal? ReceiptActualVol { get; set; }
    public decimal ReceiptVol { get; set; }
    public decimal ReceiptContractPrice { get; set; }
    public decimal? ReceiptPlaPercentage { get; set; }
    public decimal? ReceiptPlaRate { get; set; }
    public decimal? ReceiptPlaDeduct { get; set; }
    public decimal ReceiptQbRate { get; set; }
    public decimal ReceiptQbAmount { get; set; }
    public decimal ReceiptActualFee { get; set; }
    public decimal ReceiptAdjustment { get; set; }
    public decimal ReceiptPriceAdj { get; set; }
    public decimal ReceiptPurchasePrice { get; set; }
    public decimal ReceiptTransportTotal { get; set; }
    public decimal ReceiptInvoicePrice { get; set; }
    public decimal ReceiptInvoiceAmount { get; set; }
    public decimal ReceiptCrudeBasePrice { get; set; }
    public decimal ReceiptCrudeRollPrice { get; set; }
    public decimal ReceiptCrudeArgusAdj1 { get; set; }
    public decimal ReceiptCrudeArgusAdj2 { get; set; }
    public string? TneMeter { get; set; }
    public decimal Leg1Vol { get; set; }
    public string Leg1Pipe { get; set; } = "";
    public string Leg1Meter { get; set; } = "";
    public string Leg1PipeContract { get; set; } = "";
    public string Leg1PipeContractOwner { get; set; } = "";
    public decimal Leg1PipeRate { get; set; }
    public decimal Leg1PipeAmount { get; set; }
    public decimal Leg1FuelRate { get; set; }
    public decimal Leg1FuelAmount { get; set; }
    public decimal Leg2Vol { get; set; }
    public string Leg2Pipe { get; set; } = "";
    public string Leg2Meter { get; set; } = "";
    public string Leg2PipeContract { get; set; } = "";
    public string Leg2PipeContractOwner { get; set; } = "";
    public decimal Leg2PipeRate { get; set; }
    public decimal Leg2PipeAmount { get; set; }
    public decimal Leg2FuelRate { get; set; }
    public decimal Leg2FuelAmount { get; set; }
    public decimal Leg3Vol { get; set; }
    public string Leg3Pipe { get; set; } = "";
    public string Leg3Meter { get; set; } = "";
    public string Leg3PipeContract { get; set; } = "";
    public string Leg3PipeContractOwner { get; set; } = "";
    public decimal Leg3PipeRate { get; set; }
    public decimal Leg3PipeAmount { get; set; }
    public decimal Leg3FuelRate { get; set; }
    public decimal Leg3FuelAmount { get; set; }
    public decimal Leg4Vol { get; set; }
    public string Leg4Pipe { get; set; } = "";
    public string Leg4Meter { get; set; } = "";
    public string Leg4PipeContract { get; set; } = "";
    public string Leg4PipeContractOwner { get; set; } = "";
    public decimal Leg4PipeRate { get; set; }
    public decimal Leg4PipeAmount { get; set; }
    public decimal Leg4FuelRate { get; set; }
    public decimal Leg4FuelAmount { get; set; }
    public decimal Leg5Vol { get; set; }
    public string Leg5Pipe { get; set; } = "";
    public string Leg5Meter { get; set; } = "";
    public string Leg5PipeContract { get; set; } = "";
    public string Leg5PipeContractOwner { get; set; } = "";
    public decimal Leg5PipeRate { get; set; }
    public decimal Leg5PipeAmount { get; set; }
    public decimal Leg5FuelRate { get; set; }
    public decimal Leg5FuelAmount { get; set; }
    public string DeliveryDeal { get; set; } = "";
    public string DeliveryInternalEntity { get; set; } = "";
    public string DeliveryCounterparty { get; set; } = "";
    public string DeliveryCounterpartyShort { get; set; } = "";
    public string DeliveryDealPurpose { get; set; } = "";
    public string DeliveryBaseOrSwing { get; set; } = "";
    public string DeliveryPipe { get; set; } = "";
    public string DeliveryPoint { get; set; } = "";
    public string DeliveryMeter { get; set; } = "";
    public string DeliveryPipeContract { get; set; } = "";
    public string DeliveryPipeContractOwner { get; set; } = "";
    public decimal DeliveryNomVol { get; set; }
    public decimal? DeliveryActualVol { get; set; }
    public decimal DeliveryVol { get; set; }
    public decimal DeliveryContractPrice { get; set; }
    public decimal? DeliveryPlaPercentage { get; set; }
    public decimal? DeliveryPlaRate { get; set; }
    public decimal? DeliveryPlaDeduct { get; set; }
    public decimal DeliveryQbRate { get; set; }
    public decimal DeliveryQbAmount { get; set; }
    public decimal DeliveryActualFee { get; set; }
    public decimal DeliveryPriceAdj { get; set; }
    public decimal DeliveryInvoicePrice { get; set; }
    public decimal DeliveryInvoiceAmount { get; set; }
    public decimal DeliveryCrudeBasePrice { get; set; }
    public decimal DeliveryCrudeRollPrice { get; set; }
    public decimal DeliveryCrudeArgusAdj1 { get; set; }
    public decimal DeliveryCrudeArgusAdj2 { get; set; }
    public decimal DeliveryAdjustment { get; set; }
    public bool NonJurisdictional { get; set; }
    public bool IsAgency { get; set; }
    public bool IsNetback { get; set; }
    public bool HasTransfers { get; set; }
    public string? ReceiptInternalContractNum { get; set; }
    public string? ReceiptCounterpartyContractNum { get; set; }
    public string? DeliveryInternalContractNum { get; set; }
    public string? DeliveryCounterpartyContractNum { get; set; }
    public bool IsReceiptTransportOverridden { get; set; }
    public bool IsReceiptPriceAdjOverridden { get; set; }
    public bool IsReceiptContractPriceOverridden { get; set; }
    public bool IsDeliveryPriceAdjOverridden { get; set; }
    public bool IsDeliveryActualFeeOveridden { get; set; }
    public bool IsDeliveryAdjustmentOverridden { get; set; }
    public bool IsReceiptAdjustmentOverridden { get; set; }
    public bool IsReceiptActualFeeOverridden { get; set; }
    public bool IsDeliveryContractPriceOverridden { get; set; }
    public int SupplyNomId { get; set; }
    public int MarketNomId { get; set; }
    public int? LastTransferDealId { get; set; }
    public int? ReceiptDealContractId { get; set; }
    public int? DeliveryDealContractId { get; set; }
    public int? ReceiptDealId { get; set; }
    public int? ReceiptProductId { get; set; }
    public int? ReceiptInternalEntityId { get; set; }
    public int? ReceiptCounterpartyId { get; set; }
    public int? ReceiptTransferDealId { get; set; }
    public int ReceiptPipeId { get; set; }
    public int? ReceiptPointId { get; set; }
    public int ReceiptMeterId { get; set; }
    public int? ReceiptPipeContractId { get; set; }
    public int? DeliveryDealId { get; set; }
    public int? DeliveryProductId { get; set; }
    public int? DeliveryInternalEntityId { get; set; }
    public int? DeliveryCounterpartyId { get; set; }
    public int? DeliveryTransferDealId { get; set; }
    public int DeliveryPipeId { get; set; }
    public int? DeliveryPointId { get; set; }
    public int DeliveryMeterId { get; set; }
    public int? TneMeterId { get; set; }
    public int? TneMeterDeductLegNum { get; set; }
    public int? DeliveryPipeContractId { get; set; }
    public int? ReceiptPortfolioId { get; set; }
    public int? ReceiptDealPurposeId { get; set; }
    public int? DeliveryDealPurposeId { get; set; }
    public List<TransportItem> ReceiptTransports { get; set; } = new();
}

public class TransportItem()
{
    public decimal NomVol { get; set; }
    public decimal NomOrActualVol { get; set; }
    public string ReceiptPipe { get; set; } = "";
    public string PipeContract { get; set; } = "";
    public string PipeContractOwner { get; set; } = "";
    public decimal PipeRate { get; set; }
    public decimal PipeAmount { get; set; }
    public decimal FuelRate { get; set; }
    public decimal FuelAmount { get; set; }
    public int ReceiptMeterId { get; set; }
    public string ReceiptMeter { get; set; } = "";
}
