using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("w9_form")]
[Index("CounterpartyParentId", "CounterpartyId", "VersionMonth", Name = "uk_w9_form", IsUnique = true)]
public partial class W9Form
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("counterparty_id")]
    public int? CounterpartyId { get; set; }

    [Column("counterparty_parent_id")]
    public int CounterpartyParentId { get; set; }

    [Column("version_month")]
    public DateOnly VersionMonth { get; set; }

    [Column("notes", TypeName = "citext")]
    public string? Notes { get; set; }

    [ForeignKey("CounterpartyId")]
    [InverseProperty("W9FormCounterparties")]
    public virtual Counterparty? Counterparty { get; set; }

    [ForeignKey("CounterpartyParentId")]
    [InverseProperty("W9FormCounterpartyParents")]
    public virtual Counterparty CounterpartyParent { get; set; } = null!;

    [InverseProperty("W9Form")]
    public virtual ICollection<W9FormDoc> W9FormDocs { get; set; } = new List<W9FormDoc>();
}
