using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Keyless]
public partial class VwRptDeal
{
    [Column("Ticket Number", TypeName = "citext")]
    public string? TicketNumber { get; set; }

    [Column("Accounting Month")]
    public DateTime? AccountingMonth { get; set; }

    [Column("Attached LC Language")]
    public int? AttachedLcLanguage { get; set; }

    public double? Basis { get; set; }

    [Column("Unit of Basis Price")]
    public string? UnitOfBasisPrice { get; set; }

    [Column(TypeName = "citext")]
    public string? Book { get; set; }

    [Column("Broker Account", TypeName = "citext")]
    public string? BrokerAccount { get; set; }

    [Column("Executing Broker", TypeName = "citext")]
    public string? ExecutingBroker { get; set; }

    [Column("Buy/Sell", TypeName = "citext")]
    public string? BuySell { get; set; }

    [Column(TypeName = "citext")]
    public string? Comments { get; set; }

    [Column(TypeName = "citext")]
    public string? Contact { get; set; }

    [Column("Contact Phone", TypeName = "citext")]
    public string? ContactPhone { get; set; }

    [Column("Contact Fax", TypeName = "citext")]
    public string? ContactFax { get; set; }

    [Column(TypeName = "citext")]
    public string? Counterparty { get; set; }

    public DateTime? Created { get; set; }

    [Column("Created By", TypeName = "citext")]
    public string? CreatedBy { get; set; }

    [Column("Deal Purpose", TypeName = "citext")]
    public string? DealPurpose { get; set; }

    [Column("Deal Status", TypeName = "citext")]
    public string? DealStatus { get; set; }

    [Column("Deal Type", TypeName = "citext")]
    public string? DealType { get; set; }

    [Column("Delivery Mode", TypeName = "citext")]
    public string? DeliveryMode { get; set; }

    [Column(TypeName = "citext")]
    public string? Commodity { get; set; }

    [Column("End Date")]
    public DateOnly? EndDate { get; set; }

    [Column("Fixed Price")]
    public double? FixedPrice { get; set; }

    [Column("Unit Fixed Price")]
    public string? UnitFixedPrice { get; set; }

    [Column("Price Type")]
    public string? PriceType { get; set; }

    [Column(TypeName = "citext")]
    public string? Hypothetical { get; set; }

    [Column("Internal Entity", TypeName = "citext")]
    public string? InternalEntity { get; set; }

    [Column("Internal Entity ShortName", TypeName = "citext")]
    public string? InternalEntityShortName { get; set; }

    [Column("Internal Memo", TypeName = "citext")]
    public string? InternalMemo { get; set; }

    [Column("FM Language", TypeName = "citext")]
    public string? FmLanguage { get; set; }

    [Column("Is Hypothethical")]
    public bool? IsHypothethical { get; set; }

    [Column("Is Pooled Future Deal")]
    public bool? IsPooledFutureDeal { get; set; }

    [Column("Is Variable Volume")]
    public bool? IsVariableVolume { get; set; }

    [Column("Master Contract", TypeName = "citext")]
    public string? MasterContract { get; set; }

    public int? Contracts { get; set; }

    [Column("Title Pipeline", TypeName = "citext")]
    public string? TitlePipeline { get; set; }

    [Column("Title Point", TypeName = "citext")]
    public string? TitlePoint { get; set; }

    [Column("Point State", TypeName = "citext")]
    public string? PointState { get; set; }

    [Column("Source Delivery Pipeline", TypeName = "citext")]
    public string? SourceDeliveryPipeline { get; set; }

    [Column(TypeName = "citext")]
    public string? Portfolio { get; set; }

    [Column("Premium or Dicount")]
    public double? PremiumOrDicount { get; set; }

    [Column("Unit Prem Disc Price")]
    public string? UnitPremDiscPrice { get; set; }

    [Column("Price Index", TypeName = "citext")]
    public string? PriceIndex { get; set; }

    [Column("Price Index Unit")]
    public string? PriceIndexUnit { get; set; }

    [Column("Price Index 2", TypeName = "citext")]
    public string? PriceIndex2 { get; set; }

    [Column("Price Index Unit 2")]
    public string? PriceIndexUnit2 { get; set; }

    [Column("Physical Link", TypeName = "citext")]
    public string? PhysicalLink { get; set; }

    [Column(TypeName = "citext")]
    public string? Product { get; set; }

    [Column(TypeName = "citext")]
    public string? Region { get; set; }

    [Column("T & E MMBTU", TypeName = "citext")]
    public string? TEMmbtu { get; set; }

    [Column("T & E Fuel", TypeName = "citext")]
    public string? TEFuel { get; set; }

    [Column("Settle By", TypeName = "citext")]
    public string? SettleBy { get; set; }

    [Column("Start Date")]
    public DateOnly? StartDate { get; set; }

    [Column(TypeName = "citext")]
    public string? Trader { get; set; }

    [Column("Trade Date")]
    public DateOnly? TradeDate { get; set; }

    [Column("Transaction Type", TypeName = "citext")]
    public string? TransactionType { get; set; }

    [Column("Contractual Volume")]
    public double? ContractualVolume { get; set; }

    [Column("Volume Unit", TypeName = "citext")]
    public string? VolumeUnit { get; set; }

    [Column("Update Notes", TypeName = "citext")]
    public string? UpdateNotes { get; set; }

    [Column("Volume Type", TypeName = "citext")]
    public string? VolumeType { get; set; }

    [Column("WASP Number", TypeName = "citext")]
    public string? WaspNumber { get; set; }

    [Column(TypeName = "citext")]
    public string? Strategy { get; set; }

    [Column("Pipe Short", TypeName = "citext")]
    public string? PipeShort { get; set; }

    [Column("Counterparty Nickname", TypeName = "citext")]
    public string? CounterpartyNickname { get; set; }

    [Column("BookID")]
    public int? BookId { get; set; }

    [Column("BuyButtonID")]
    public int? BuyButtonId { get; set; }

    [Column("CounterPartyID")]
    public int? CounterPartyId { get; set; }

    [Column("DealPurposeID")]
    public int? DealPurposeId { get; set; }

    [Column("InternalEntityID")]
    public int? InternalEntityId { get; set; }

    [Column("PipelineID")]
    public int? PipelineId { get; set; }

    [Column("PipelineSourceDeliveryID")]
    public int? PipelineSourceDeliveryId { get; set; }

    [Column("PointID")]
    public int? PointId { get; set; }

    [Column("PortfolioID")]
    public int? PortfolioId { get; set; }

    [Column("RegionID")]
    public int? RegionId { get; set; }

    [Column("StrategyID")]
    public int? StrategyId { get; set; }

    [Column("TraderID")]
    public int? TraderId { get; set; }

    [Column("TransactionTypeID")]
    public int? TransactionTypeId { get; set; }
}
